/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// TSecDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "TSecDialog.h"

#include "funcheader.h"
#include "section.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTSecDialog dialog


CTSecDialog::CTSecDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CTSecDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTSecDialog)
	m_tVerticalThickness = 0.0;
	m_tHorizontalThickness = 0.0;
	m_tLength = 0.0;
	m_tWidth = 0.0;
	m_tExtHeight = 0.0;
	m_check1 = FALSE;
	m_blendRadius = 0.0;
	//}}AFX_DATA_INIT
}


void CTSecDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTSecDialog)
	DDX_Text(pDX, IDC_TEDIT1, m_tVerticalThickness);
	DDV_MinMaxDouble(pDX, m_tVerticalThickness, 1.e-005, 10000.);
	DDX_Text(pDX, IDC_TEDIT2, m_tHorizontalThickness);
	DDV_MinMaxDouble(pDX, m_tHorizontalThickness, 1.e-005, 10000.);
	DDX_Text(pDX, IDC_TEDIT3, m_tLength);
	DDV_MinMaxDouble(pDX, m_tLength, 1.e-005, 10000.);
	DDX_Text(pDX, IDC_TEDIT4, m_tWidth);
	DDV_MinMaxDouble(pDX, m_tWidth, 1.e-005, 10000.);
	DDX_Text(pDX, IDC_TEDIT5, m_tExtHeight);
	DDV_MinMaxDouble(pDX, m_tExtHeight, 1.e-005, 10000.);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	DDX_Text(pDX, IDC_TEDIT6, m_blendRadius);
//	DDV_MinMaxDouble(pDX, m_blendRadius, 1.e-004, 1000.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTSecDialog, CDialog)
	//{{AFX_MSG_MAP(CTSecDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTSecDialog message handlers

void CTSecDialog::OnOK() 
{
	HRESULT status = CONV_SUCCESS;

	ISet *objset1 = NULL;
	UpdateData(TRUE);
	if(!m_check1)
		m_blendRadius = 0.0;

	if(m_tLength >0 && m_tVerticalThickness > 0 && m_tHorizontalThickness > 0
		&& m_tWidth > 0 && m_tExtHeight > 0
		&& m_tVerticalThickness < m_tLength && m_tVerticalThickness < m_tWidth
		&& m_tHorizontalThickness < m_tLength && m_tHorizontalThickness < m_tWidth) {
		
		status = CreateTSection(m_tLength/1000, m_tVerticalThickness/1000,
			m_tHorizontalThickness/1000, m_tWidth/1000, m_tExtHeight/1000, m_blendRadius/1000, &objset1);
		if(status != 0|| !objset1){
			AfxMessageBox("CreateTSection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
